<?php

namespace App\Livewire\Frontend;
use App\Models\Misc as ModelsMisc;
use App\Models\History as ModelsHistory;
use Livewire\Component;

class Index extends Component
{   
    public $miscdata;
    public $lastid;

    public function render()
    {   
        $data = ModelsHistory::orderBy('id', 'desc')->limit(8)->skip(1)->get();
        return view('livewire.frontend.index', ['dataResults' => $data]);
    }

    public function mount()
    {   
        $this->lastid = ModelsHistory::orderBy('id', 'desc')->latest()->first();
        $this->miscdata = ModelsMisc::where('id', 1)->first(); 
    }

}