<?php $totalRecords = App\Models\History::all()->count(); ?>
@if ($paginator->hasPages())
    <ul class="flex justify-around p-5 text-gray-500 text-sm font-medium">
        @if ($paginator->onFirstPage())
            <li class="text-lg paginate-disable text-gray-300">Prev</li>
        @else
            <li class="text-lg cursor-pointer px-3 py-1 rounded-md bg-color-color1 text-color-color4" wire:click="previousPage">Prev</li>
        @endif
            <li class="font-light text-md flex justify-center items-center text-color-color4">{{ $totalRecords }} total records</li>
        @if ($paginator->hasMorePages())
            <li class="text-lg cursor-pointer px-3 py-1 rounded-md bg-color-color1 text-color-color4" wire:click="nextPage">Next</li>
        @else
            <li class="text-lg paginate-disable text-gray-300">Next</li>
        @endif
    </ul>
@endif