<div>
        <div class="py-[6rem] bg-[url('../img/bg-top.png')] bg-top bg-no-repeat bg-cover">
            <h1 class="text-center text-color-color4 text-4xl">All Results</h1>
        </div>
        <section id="lastResults">
            <div class="bg-color-color3 relative bg-[url('../img/splash.png')] bg-center bg-no-repeat bg-cover">
                <img class="lg:block hidden absolute left-0 top-0 w-[260px]" src="<?php echo e(asset('assets/img/leafs-1.png')); ?>" alt="Leafs">
                <img class="lg:block hidden absolute right-0 bottom-0 w-[235px]" src="<?php echo e(asset('assets/img/leafs-2.png')); ?>" alt="Leafs">
                <div class="mx-auto max-w-[1000px]">
                    <div class="lg:py-12 px-3 py-6">
                        <?php echo e($dataResults->links('pagination-links2')); ?>

                        <div class="bg-color-color1 rounded-2xl lg:py-10 lg:px-8 lg:my-3 px-5 py-10 lg:z-[100] lg:relative">
                            <div class="grid lg:grid-cols-4">
                                <h2 class="font-joti text-color-color4 text-2xl lg:col-span-3 flex lg:items-center lg:justify-start justify-center lg:mb-0   mb-5">All Results</h2>
                                <input wire:model.live="keyword" class="rounded-full text-center text-sm bg-color-color4" placeholder="Search Numbers/Day/Date.." type="text" autofocus>
                            </div>
                            <div class="mt-5">
                                <!--[if BLOCK]><![endif]--><?php if($dataResults->isEmpty() && $keyword !== null): ?>
                                <div class="text-color-color4 text-center text-lg mt-20">
                                    No results found for "<?php echo e($keyword); ?>".
                                </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $dataResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="grid lg:grid-cols-3 grid-cols-2 border-b-[1px] border-color-color2 py-4 px-3 last:border-b-0">
                                    <div class="lg:col-span-2 text-color-color4 lg:text-lg text-sm flex items-center">
                                    <?php echo e(Str::substr($result->day, 0, 3)); ?>,
                                    <?php echo e(\Carbon\Carbon::parse($result->date)->format('j-m-Y')); ?>

                                    </div>
                                    <div class="text-color-color4 text-xl flex justify-end lg:gap-6 gap-3">
                                        <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md"><?php echo e(Str::substr($result->p_1st, 0, 1)); ?></span>
                                        <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md"><?php echo e(Str::substr($result->p_1st, 1, 1)); ?></span>
                                        <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md"><?php echo e(Str::substr($result->p_1st, 2, 1)); ?></span>
                                        <span class="bg-color-color2 w-[35px] h-[35px] flex justify-center items-center rounded-md"><?php echo e(Str::substr($result->p_1st, 3, 1)); ?></span>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <?php echo e($dataResults->links('pagination-links2')); ?>

                    </div>
                </div>
            </div>
        </section>
    </div>

    <?php
    $endTime = strtotime($miscdata->timer_end);
    $end = date('M d, Y H:i:s', $endTime);
    ?>

    <script>
        var countDownDate = new Date('<?= $end ?>').getTime();
        var now = new Date().getTime();
        var distance = countDownDate - now;
        const onDrawing = document.getElementById('onDrawing');

        if (distance <= 300000) {
            onDrawing.classList.replace('hidden', 'flex');
            var x = setTimeout(() => {
                window.location.href = '<?php echo e(url('/')); ?>';
            }, 1000);
        }
        
        if (distance < -20000) {
            onDrawing.classList.replace('flex', 'hidden');
            clearTimeout(x);
        }
    </script><?php /**PATH /home/bocorantototix/public_html/brazilpools/laravel/resources/views/livewire/frontend/results.blade.php ENDPATH**/ ?>