import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
                joti: ['"Joti One"', 'serif'],
            },
            colors: {
                'color-color1': '#052e16',
                'color-color2': '#15803d',
                'color-color3': '#14532d',
                'color-color4': '#bbf7d0',
                'color-color5': '#4ade80',
            },
        },
    },

    plugins: [forms],
};
